// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef MOL_COMPILE_TEST_HPP
#define MOL_COMPILE_TEST_HPP

#include <mol/detail/compile_test.hpp>
#include <mol/detail/test_name.hpp>
#include <type_traits>

#ifndef MOL_COMPILE_TEST_DISABLE
// NOLINTNEXTLINE(cppcoreguidelines-macro-usage)
#define MOL_COMPILE_TEST(condition)                                                                \
  MOL_DETAIL_COMPILE_TEST_IMPL(MOL_DETAIL_TEST_NAME(__COUNTER__), condition)
#else
// NOLINTNEXTLINE(cppcoreguidelines-macro-usage)
#define MOL_COMPILE_TEST(condition)                                                                \
  MOL_DETAIL_COMPILE_TEST_DUMMY_IMPL(MOL_DETAIL_TEST_NAME(__COUNTER__), condition)
#endif
#endif // MOL_COMPILE_TEST_HPP
