// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef MOL_DEPENDENT_FALSE_HPP
#define MOL_DEPENDENT_FALSE_HPP

#include <mol/detail/dependent_false.hpp>
#include <utility>

namespace mol {
template <class T>
struct dependent_false : std::false_type {};

template <>
struct dependent_false<detail::dependent_false_dummy_class> : std::true_type {};

template <typename T>
constexpr inline auto dependent_false_v = dependent_false<T>::value;
} // namespace mol

#endif // MOL_DEPENDENT_FALSE_HPP
