// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef MOL_DETAIL_COMPILE_TEST_HPP
#define MOL_DETAIL_COMPILE_TEST_HPP

#include <mol/detail/test_name.hpp>

// NOLINTNEXTLINE(cppcoreguidelines-macro-usage)
#define MOL_DETAIL_COMPILE_TEST_IMPL(test_name, condition)                                         \
  template <typename T, bool b, typename std::enable_if_t<!b>* = nullptr>                          \
  void test_name()                                                                                 \
  {                                                                                                \
  }                                                                                                \
  template <typename T, bool b, typename std::enable_if_t<b>* = nullptr>                           \
  void test_name();                                                                                \
  void test_name_##instantiate();                                                                  \
  void test_name_##instantiate()                                                                   \
  {                                                                                                \
    MOL_DETAIL_TEST_ID(test_name)<int, condition>();                                               \
  }                                                                                                \
  template <typename T, bool b, typename std::enable_if_t<b>*>                                     \
  void test_name()

// NOLINTNEXTLINE(cppcoreguidelines-macro-usage)
#define MOL_DETAIL_COMPILE_TEST_DUMMY_IMPL(test_name, condition)                                   \
  template <typename T, bool b, typename std::enable_if_t<b>* = nullptr>                           \
  void test_name()

#endif // MOL_DETAIL_COMPILE_TEST_HPP
