// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef NOLA_DEPENDENT_FALSE_HPP
#define NOLA_DEPENDENT_FALSE_HPP

#include <nola/detail/dependent_false.hpp>
#include <utility>

namespace nola {
template <class T>
struct dependent_false : std::false_type {};

template <>
struct dependent_false<detail::dependent_false_dummy_class> : std::true_type {};

template <typename T>
constexpr inline auto dependent_false_v = dependent_false<T>::value;
} // namespace nola

#endif // NOLA_DEPENDENT_FALSE_HPP
