// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef ZELL_IO_VTK_UGRID_CELL_NVERTEX_HPP
#define ZELL_IO_VTK_UGRID_CELL_NVERTEX_HPP

#include <zell/io/vtk/ugrid/cell_type.hpp>

namespace zell::io::vtk::ugrid {
constexpr auto cell_nvertex(cell_type type) noexcept -> std::size_t
{
  switch (type) {
  case cell_type::vertex:
    return 1;
  case cell_type::line:
    return 2;
  case cell_type::triangle:
    return 3;
  case cell_type::quad:
  case cell_type::tetra:
    return 4;
  case cell_type::hexahedron:
    return 8;
  default:
    return 0;
  }
}
} // namespace zell::io::vtk::ugrid

#endif // ZELL_IO_VTK_UGRID_CELL_NVERTEX_HPP
