// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef ZELL_IO_VTK_UGRID_CELL_VIEW_HPP
#define ZELL_IO_VTK_UGRID_CELL_VIEW_HPP

#include <nola/wrap_iterator.hpp>
#include <zell/io/vtk/ugrid/cell_type.hpp>

namespace zell::io::vtk::ugrid {
class cell_view {
public:
  using value_type = std::size_t;

  using reference = value_type&;
  using const_reference = value_type const&;

  using pointer = value_type*;
  using const_pointer = value_type const*;

  using iterator = nola::wrap_iterator<pointer>;
  using const_iterator = nola::wrap_iterator<const_pointer>;

  using size_type = std::size_t;
  using difference_type = std::ptrdiff_t;

  using reverse_iterator = std::reverse_iterator<iterator>;
  using const_reverse_iterator = std::reverse_iterator<const_iterator>;

public:
  cell_view() = default;

  cell_view(cell_type type, pointer begin, pointer end);

public:
  auto begin() const noexcept -> const_iterator;
  auto begin() noexcept -> iterator;

  auto end() const noexcept -> const_iterator;
  auto end() noexcept -> iterator;

  auto operator[](size_type index) noexcept -> reference;
  auto operator[](size_type index) const noexcept -> const_reference;

  auto type() const noexcept -> cell_type;

private:
  iterator begin_{nullptr};
  iterator end_{nullptr};
  cell_type type_;
};
} // namespace zell::io::vtk::ugrid

#endif // ZELL_IO_VTK_UGRID_CELL_VIEW_HPP
