// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef ZELL_IO_VTK_UGRID_DETAIL_SCALAR_DATA_BASE_HPP
#define ZELL_IO_VTK_UGRID_DETAIL_SCALAR_DATA_BASE_HPP

#include <string>
#include <zell/io/vtk/ugrid/data_type.hpp>
#include <zell/io/vtk/ugrid/pmdata.hpp>

namespace zell::io::vtk::ugrid::detail {
class scalar_data_base : public pmdata {

public:
  scalar_data_base() = default;
  scalar_data_base(scalar_data_base const&) = default;
  scalar_data_base(scalar_data_base&&) noexcept = default;
  auto operator=(scalar_data_base const&) -> scalar_data_base& = default;
  auto operator=(scalar_data_base&&) noexcept -> scalar_data_base& = default;
  ~scalar_data_base() override = default;

public:
  auto name() const noexcept -> std::string const& override = 0;
  auto data() const noexcept -> struct data_type override = 0;
  auto dataset() const noexcept -> dataset_type final { return dataset_type::scalar; }
  virtual auto ncomponent() const noexcept -> std::size_t = 0;
};

} // namespace zell::io::vtk::ugrid::detail

#endif // ZELL_IO_VTK_UGRID_DETAIL_SCALAR_DATA_BASE_HPP
