// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef ZELL_IO_VTK_UGRID_DETAIL_SCALAR_HEADER_HPP
#define ZELL_IO_VTK_UGRID_DETAIL_SCALAR_HEADER_HPP

#include <zell/io/vtk/ugrid/data_type.hpp>

namespace zell::io::vtk::ugrid::detail {
template <typename Alloc>
class scalar_header {
public:
  using allocator_type = Alloc;

private:
  using char_allocator = typename std::allocator_traits<Alloc>::template rebind_alloc<char>;

public:
  using string_type = std::basic_string<char, std::char_traits<char>, char_allocator>;

public:
  scalar_header() = default;
  explicit scalar_header(allocator_type const& alloc);

public:
  auto set_name(string_type const& name) -> void;
  auto set_data(data_type const& data) -> void;
  auto set_ncomponent(std::size_t ncomponent) -> void;
  auto set_lookup_table(string_type const& lookup_table) -> void;

  auto name() const noexcept -> string_type const&;
  auto data() const noexcept -> data_type;
  auto ncomponent() const noexcept -> std::size_t;
  auto lookup_table() const noexcept -> string_type;

private:
  string_type name_;
  string_type lookup_table_;
  data_type data_;
  std::size_t ncomponent_{};
};

template <typename Alloc>
scalar_header<Alloc>::scalar_header(allocator_type const& alloc) : name_(alloc)
{
}

template <typename Alloc>
auto scalar_header<Alloc>::set_name(string_type const& name) -> void
{
  name_ = name;
}

template <typename Alloc>
auto scalar_header<Alloc>::set_data(data_type const& data) -> void
{
  data_ = data;
}

template <typename Alloc>
auto scalar_header<Alloc>::set_ncomponent(std::size_t ncomponent) -> void
{
  ncomponent_ = ncomponent;
}

template <typename Alloc>
auto scalar_header<Alloc>::name() const noexcept -> string_type const&
{
  return name_;
}

template <typename Alloc>
auto scalar_header<Alloc>::data() const noexcept -> data_type
{
  return data_;
}

template <typename Alloc>
auto scalar_header<Alloc>::ncomponent() const noexcept -> std::size_t
{
  return ncomponent_;
}

template <typename Alloc>
auto scalar_header<Alloc>::lookup_table() const noexcept -> string_type
{
  return lookup_table_;
}

template <typename Alloc>
auto scalar_header<Alloc>::set_lookup_table(string_type const& lookup_table) -> void
{
  lookup_table_ = lookup_table;
}
} // namespace zell::io::vtk::ugrid::detail

#endif // ZELL_IO_VTK_UGRID_DETAIL_SCALAR_HEADER_HPP
