// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef ZELL_IO_VTK_UGRID_DETAIL_VECTOR_DATA_BASE_HPP
#define ZELL_IO_VTK_UGRID_DETAIL_VECTOR_DATA_BASE_HPP

#include <string>
#include <zell/io/vtk/ugrid/data_type.hpp>
#include <zell/io/vtk/ugrid/dataset_type.hpp>
#include <zell/io/vtk/ugrid/pmdata.hpp>

namespace zell::io::vtk::ugrid::detail {
class vector_data_base : public pmdata {

public:
  vector_data_base() = default;
  ~vector_data_base() override = default;

public:
  auto name() const noexcept -> std::string const& override = 0;
  auto data() const noexcept -> data_type override = 0;
  auto dataset() const noexcept -> dataset_type final;
};

} // namespace zell::io::vtk::ugrid::detail

#endif // ZELL_IO_VTK_UGRID_DETAIL_VECTOR_DATA_BASE_HPP
