// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef ZELL_IO_VTK_UGRID_DETAIL_VECTOR_HEADER_HPP
#define ZELL_IO_VTK_UGRID_DETAIL_VECTOR_HEADER_HPP

#include <zell/io/vtk/ugrid/data_type.hpp>

namespace zell::io::vtk::ugrid::detail {
template <typename Alloc>
class vector_header {

public:
  using allocator_type = Alloc;

private:
  using char_allocator = typename allocator_type::template rebind<char>::other;

public:
  using string_type = std::basic_string<char, std::char_traits<char>, char_allocator>;

public:
  vector_header() = default;
  explicit vector_header(allocator_type const& alloc);

public:
  auto set_name(string_type const& name) -> void;
  auto set_data(data_type const& data) -> void;

  auto name() const noexcept -> string_type const&;
  auto data() const noexcept -> data_type;

private:
  string_type name_;
  data_type data_;
};

template <typename Alloc>
vector_header<Alloc>::vector_header(allocator_type const& alloc) : name_(alloc)
{
}

template <typename Alloc>
auto vector_header<Alloc>::set_name(string_type const& name) -> void
{
  name_ = name;
}

template <typename Alloc>
auto vector_header<Alloc>::set_data(data_type const& data) -> void
{
  data_ = data;
}

template <typename Alloc>
auto vector_header<Alloc>::name() const noexcept -> string_type const&
{
  return name_;
}

template <typename Alloc>
auto vector_header<Alloc>::data() const noexcept -> data_type
{
  return data_;
}


} // namespace zell::io::vtk::ugrid::detail

#endif // ZELL_IO_VTK_UGRID_DETAIL_VECTOR_HEADER_HPP
