// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef ZELL_IO_VTK_UGRID_PMDATA_HPP
#define ZELL_IO_VTK_UGRID_PMDATA_HPP

#include <string>
#include <zell/io/vtk/ugrid/data_type.hpp>
#include <zell/io/vtk/ugrid/dataset_type.hpp>

namespace zell::io::vtk::ugrid {
class pmdata {

public:
  pmdata() = default;
  pmdata(pmdata const&) = default;
  pmdata(pmdata&&) noexcept = default;
  auto operator=(pmdata const&) -> pmdata& = default;
  auto operator=(pmdata&&) noexcept -> pmdata& = default;
  virtual ~pmdata() = default;

public:
  virtual auto name() const noexcept -> std::string const& = 0;
  virtual auto data() const noexcept -> data_type = 0;
  virtual auto dataset() const noexcept -> dataset_type = 0;
};

} // namespace zell::io::vtk::ugrid

#endif // ZELL_IO_VTK_UGRID_PMDATA_HPP
