// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#ifndef ZELL_IO_VTK_UGRID_TYPE_MAP_HPP
#define ZELL_IO_VTK_UGRID_TYPE_MAP_HPP

#include <cstdint>
#include <zell/io/vtk/ugrid/data_type.hpp>

namespace zell::io::vtk::ugrid {
template <data_type e>
struct type_map;

template <>
struct type_map<data_type::integer32> {
  using type = std::int32_t;
};

template <>
struct type_map<data_type::integer64> {
  using type = std::int64_t;
};

template <>
struct type_map<data_type::binary32> {
  using type = float;
};

template <>
struct type_map<data_type::binary64> {
  using type = double;
};

template <typename F>
struct reverse_type_map;

template <>
struct reverse_type_map<std::int32_t> {
  static constexpr auto value = data_type::integer32;
};

template <>
struct reverse_type_map<std::int64_t> {
  static constexpr auto value = data_type::integer64;
};

template <>
struct reverse_type_map<float> {
  static constexpr auto value = data_type::binary32;
};

template <>
struct reverse_type_map<double> {
  static constexpr auto value = data_type::binary64;
};

} // namespace zell::io::vtk::ugrid

#endif // ZELL_IO_VTK_UGRID_TYPE_MAP_HPP
