// -------------------------------------------------------------------------------------------------
// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: (C) 2022 Jayesh Badwaik <j.badwaik@fz-juelich.de>
// -------------------------------------------------------------------------------------------------

#include <zell/io/vtk/ugrid/cell_view.hpp>

#include <iostream>

namespace zell::io::vtk::ugrid {

cell_view::cell_view(cell_type type, pointer begin, pointer end)
: begin_(begin), end_(end), type_(type)
{
}

auto cell_view::begin() const noexcept -> const_iterator
{
  return const_iterator(begin_);
}

auto cell_view::end() const noexcept -> const_iterator
{
  return const_iterator(end_);
}

auto cell_view::begin() noexcept -> iterator
{
  return begin_;
}

auto cell_view::end() noexcept -> iterator
{
  return end_;
}

auto cell_view::operator[](size_type index) noexcept -> reference
{
  return begin_[static_cast<difference_type>(index)];
}

auto cell_view::operator[](size_type index) const noexcept -> const_reference
{
  return begin_[static_cast<difference_type>(index)];
}

auto cell_view::type() const noexcept -> cell_type
{
  return type_;
}

} // namespace zell::io::vtk::ugrid
