#!/usr/bin/make -f
# Generates a tar with all files needed to view the HTML presetnation properly
# -Andreas Herten, 2021 May 26
.PHONY: all
all: static-slides-bundle.tar.gz static-slides-bundle.zip

SOURCES=Introduction-to-Pandas--slides.html img/ fzj-reveal.js/img/ fzj-reveal.js/reveal.js fzj-reveal.js/custom.css fzj-reveal.js/fzj.js

static-slides-bundle.tar.gz: gen-static-slides-bundle.mk $(SOURCES)
	tar czf $@ --transform 's,^,pandas-tutorial-slides/,' $(SOURCES)

static-slides-bundle.zip: gen-static-slides-bundle.mk $(SOURCES) static-slides-bundle.tar.gz
	tar xf static-slides-bundle.tar.gz
	zip -9 -r $@ pandas-tutorial-slides/
	rm -rf pandas-tutorial-slides